/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/***
 *\file  : *\file  : Dm8127_Common.h
 *
 *\brief : Header file for the functions and variables which is common for
 *         all the files used in the DM8127_CSK_PROJECT.
 *
 *\Descr : This header file contains the Macros, Macro functions, functions
 *         prototype and variables which is common for all the intearfaces
 *         used in the CSK project using processor DM8127.
 *
 *         Because the dependency of source/Heade files used in the DM8127_CSK
 *         on this header file so user has to keep mind on the another interfaces
 *         also, when he changes anything related to particular interfces.
 *         so that the behaviour of the another interfaces should not change.
 *
 *\Author : Antriksh
 *\Version: 01a,28Sep2016, An created.
 */

#ifndef _DM8127_COMMON_H_
#define _DM8127_COMMON_H_

#ifdef __cplusplus
 extern "C" {
#endif


/*
 *=====================
 * Includes
 *=====================
 */
#include "DM8127_types.h"
#include "DM8127_EVM.h"
#include "sdio.h"
#include "uart.h"
#include <stdio.h>
#include <string.h>
#include "gpio.h"
#include "camera.h"

 /*
  *===================
  * Global variables
  *===================
  */
 UART_Handle Hanhler_uart0;
 static UINT32 uart_timeout ;
 UINT32 CLKOUT;

/*
 *=====================
 * Defines
 *=====================
 */

#define TRUE (1u)
#define PLATFORM_TEST_AUTO_ALL     (0)
#define PLATFORM_TEST_START        (1u)
#define PLATFORM_AUTO_TEST_COUNT   (11)
#define PLATFORM_TEST_COUNT        (12)

 /*====================
  *  BASE ADDRESS
  *====================*/
#define PLL_BASE_ADDRESS        (0x481C5000)
#define PRCM_BASE_ADDR			(0x48180000)
#define CTRL_MODULE_BASE_ADDR	(0x48140000)


#define DEVOSC_REG              (PRCM_BASE_ADDR + 0x0468)

 /*=========================
  * Pincntrl Configurations
  *=========================*/

///* SD card*/
#define GMII_SELECT (CTRL_MODULE_BASE_ADDR + 0x0650)
#define	PINCNTL1	(CTRL_MODULE_BASE_ADDR + 0x0800)
#define	PINCNTL2	(CTRL_MODULE_BASE_ADDR + 0x0804)
#define	PINCNTL3	(CTRL_MODULE_BASE_ADDR + 0x0808)
#define	PINCNTL4	(CTRL_MODULE_BASE_ADDR + 0x080C)
#define	PINCNTL5	(CTRL_MODULE_BASE_ADDR + 0x0810)
#define	PINCNTL6	(CTRL_MODULE_BASE_ADDR + 0x0814)
#define	PINCNTL7	(CTRL_MODULE_BASE_ADDR + 0x0818)
#define	PINCNTL8	(CTRL_MODULE_BASE_ADDR + 0x081C)
#define	PINCNTL9	(CTRL_MODULE_BASE_ADDR + 0x0820)
#define	PINCNTL10	(CTRL_MODULE_BASE_ADDR + 0x0824)
#define	PINCNTL11	(CTRL_MODULE_BASE_ADDR + 0x0828)
#define	PINCNTL12	(CTRL_MODULE_BASE_ADDR + 0x082C)
#define	PINCNTL13	(CTRL_MODULE_BASE_ADDR + 0x0830)
#define	PINCNTL14	(CTRL_MODULE_BASE_ADDR + 0x0834)
#define	PINCNTL15	(CTRL_MODULE_BASE_ADDR + 0x0838)
#define	PINCNTL16	(CTRL_MODULE_BASE_ADDR + 0x083C)
//#define	PINCNTL17	(CTRL_MODULE_BASE_ADDR + 0x0840)
//#define	PINCNTL18	(CTRL_MODULE_BASE_ADDR + 0x0844)
//#define	PINCNTL19	(CTRL_MODULE_BASE_ADDR + 0x0848)
//#define	PINCNTL20	(CTRL_MODULE_BASE_ADDR + 0x084C)
//#define	PINCNTL21	(CTRL_MODULE_BASE_ADDR + 0x0850)
//#define	PINCNTL22	(CTRL_MODULE_BASE_ADDR + 0x0854)
//#define	PINCNTL23	(CTRL_MODULE_BASE_ADDR + 0x0858)
//#define	PINCNTL24	(CTRL_MODULE_BASE_ADDR + 0x085C)
//#define	PINCNTL25	(CTRL_MODULE_BASE_ADDR + 0x0860)
//#define	PINCNTL26	(CTRL_MODULE_BASE_ADDR + 0x0864)
//#define	PINCNTL27	(CTRL_MODULE_BASE_ADDR + 0x0868)
//#define	PINCNTL28	(CTRL_MODULE_BASE_ADDR + 0x086C)
//#define	PINCNTL29	(CTRL_MODULE_BASE_ADDR + 0x0870)
//#define	PINCNTL30	(CTRL_MODULE_BASE_ADDR + 0x0874)
//#define	PINCNTL31	(CTRL_MODULE_BASE_ADDR + 0x0878)
//#define	PINCNTL32	(CTRL_MODULE_BASE_ADDR + 0x087C)
//#define	PINCNTL33	(CTRL_MODULE_BASE_ADDR + 0x0880)
//#define	PINCNTL34	(CTRL_MODULE_BASE_ADDR + 0x0884)
//#define	PINCNTL35	(CTRL_MODULE_BASE_ADDR + 0x0888)
//#define	PINCNTL36	(CTRL_MODULE_BASE_ADDR + 0x088C)
//#define	PINCNTL37	(CTRL_MODULE_BASE_ADDR + 0x0890)
//#define	PINCNTL38	(CTRL_MODULE_BASE_ADDR + 0x0894)
#define	PINCNTL39	(CTRL_MODULE_BASE_ADDR + 0x0898)
#define	PINCNTL40	(CTRL_MODULE_BASE_ADDR + 0x089C)
#define	PINCNTL41	(CTRL_MODULE_BASE_ADDR + 0x08A0)
#define	PINCNTL42	(CTRL_MODULE_BASE_ADDR + 0x08A4)
#define	PINCNTL43	(CTRL_MODULE_BASE_ADDR + 0x08A8)
#define	PINCNTL44	(CTRL_MODULE_BASE_ADDR + 0x08AC)
//#define	PINCNTL45	(CTRL_MODULE_BASE_ADDR + 0x08B0)
//#define	PINCNTL46	(CTRL_MODULE_BASE_ADDR + 0x08B4)
//#define	PINCNTL47	(CTRL_MODULE_BASE_ADDR + 0x08B8)
//#define	PINCNTL48	(CTRL_MODULE_BASE_ADDR + 0x08BC)
//#define	PINCNTL49	(CTRL_MODULE_BASE_ADDR + 0x08C0)
//#define	PINCNTL50	(CTRL_MODULE_BASE_ADDR + 0x08C4)
//#define	PINCNTL51	(CTRL_MODULE_BASE_ADDR + 0x08C8)
//#define	PINCNTL52	(CTRL_MODULE_BASE_ADDR + 0x08CC)
//#define	PINCNTL53	(CTRL_MODULE_BASE_ADDR + 0x08D0)
//#define	PINCNTL54	(CTRL_MODULE_BASE_ADDR + 0x08D4)
//#define	PINCNTL55	(CTRL_MODULE_BASE_ADDR + 0x08D8)
//#define	PINCNTL56	(CTRL_MODULE_BASE_ADDR + 0x08DC)
 //#define PINCNTL57	(CTRL_MODULE_BASE_ADDR + 0x08e0)
 //#define PINCNTL59	(CTRL_MODULE_BASE_ADDR + 0x08e8)
 //#define PINCNTL60	(CTRL_MODULE_BASE_ADDR + 0x08ec)
#define	PINCNTL57	(CTRL_MODULE_BASE_ADDR + 0x08E0)
//#define	PINCNTL58	(CTRL_MODULE_BASE_ADDR + 0x08E4)
//#define	PINCNTL59	(CTRL_MODULE_BASE_ADDR + 0x08E8)
//#define	PINCNTL60	(CTRL_MODULE_BASE_ADDR + 0x08EC)
//#define	PINCNTL61	(CTRL_MODULE_BASE_ADDR + 0x08F0)
#define	PINCNTL62	(CTRL_MODULE_BASE_ADDR + 0x08F4)
//#define	PINCNTL63	(CTRL_MODULE_BASE_ADDR + 0x08F8)
//#define	PINCNTL64	(CTRL_MODULE_BASE_ADDR + 0x08FC)
#define	PINCNTL65	(CTRL_MODULE_BASE_ADDR + 0x0900)
//#define	PINCNTL66	(CTRL_MODULE_BASE_ADDR + 0x0904)
//#define	PINCNTL67	(CTRL_MODULE_BASE_ADDR + 0x0908)
//
//
//#define PINCNTL68	(CTRL_MODULE_BASE_ADDR + 0x090C)
//#define PINCNTL69	(CTRL_MODULE_BASE_ADDR + 0x0910)
//#define PINCNTL72	(CTRL_MODULE_BASE_ADDR + 0x091C)
//#define PINCNTL73	(CTRL_MODULE_BASE_ADDR + 0x0920)
#define PINCNTL74   (CTRL_MODULE_BASE_ADDR + 0x0924)
#define PINCNTL75   (CTRL_MODULE_BASE_ADDR + 0x0928)
//#define PINCNTL76   (CTRL_MODULE_BASE_ADDR + 0x092C)
//#define PINCNTL77   (CTRL_MODULE_BASE_ADDR + 0x0930)
#define PINCNTL78   (CTRL_MODULE_BASE_ADDR + 0x0934)
#define PINCNTL79   (CTRL_MODULE_BASE_ADDR + 0x0938)
#define PINCNTL89	(CTRL_MODULE_BASE_ADDR + 0x0960)
#define PINCNTL90	(CTRL_MODULE_BASE_ADDR + 0x0964)
#define PINCNTL91	(CTRL_MODULE_BASE_ADDR + 0x0968)
#define PINCNTL92	(CTRL_MODULE_BASE_ADDR + 0x096C)
#define PINCNTL93	(CTRL_MODULE_BASE_ADDR + 0x0970)
#define PINCNTL94	(CTRL_MODULE_BASE_ADDR + 0x0974)
#define PINCNTL95	(CTRL_MODULE_BASE_ADDR + 0x0978)
#define PINCNTL96	(CTRL_MODULE_BASE_ADDR + 0x097C)
#define PINCNTL97	(CTRL_MODULE_BASE_ADDR + 0x0980)
#define PINCNTL98	(CTRL_MODULE_BASE_ADDR + 0x0984)
#define PINCNTL99	(CTRL_MODULE_BASE_ADDR + 0x0988)
#define PINCNTL100	(CTRL_MODULE_BASE_ADDR + 0x098C)
#define PINCNTL101	(CTRL_MODULE_BASE_ADDR + 0x0990)
#define PINCNTL102	(CTRL_MODULE_BASE_ADDR + 0x0994)
#define PINCNTL103	(CTRL_MODULE_BASE_ADDR + 0x0998)
#define PINCNTL104	(CTRL_MODULE_BASE_ADDR + 0x099C)
#define PINCNTL105	(CTRL_MODULE_BASE_ADDR + 0x09A0)
#define PINCNTL106	(CTRL_MODULE_BASE_ADDR + 0x09A4)
#define PINCNTL107	(CTRL_MODULE_BASE_ADDR + 0x09A8)
#define PINCNTL108	(CTRL_MODULE_BASE_ADDR + 0x09AC)
#define PINCNTL109	(CTRL_MODULE_BASE_ADDR + 0x09B0)
#define PINCNTL110	(CTRL_MODULE_BASE_ADDR + 0x09B4)
#define PINCNTL111	(CTRL_MODULE_BASE_ADDR + 0x09B8)
 #define PINCNTL112	(CTRL_MODULE_BASE_ADDR + 0x09BC)
 //#define	PINCNTL115	(CTRL_MODULE_BASE_ADDR + 0x09C8)
//#define PINCNTL121  (CTRL_MODULE_BASE_ADDR + 0x09E0)
#define PINCNTL122	(CTRL_MODULE_BASE_ADDR + 0x09E4)
#define PINCNTL123	(CTRL_MODULE_BASE_ADDR + 0x09E8)
#define PINCNTL124	(CTRL_MODULE_BASE_ADDR + 0x09EC)
#define PINCNTL125	(CTRL_MODULE_BASE_ADDR + 0x09F0)
#define PINCNTL126	(CTRL_MODULE_BASE_ADDR + 0x09F4)
#define PINCNTL127	(CTRL_MODULE_BASE_ADDR + 0x09F8)
#define PINCNTL128	(CTRL_MODULE_BASE_ADDR + 0x09FC)
#define PINCNTL129	(CTRL_MODULE_BASE_ADDR + 0x0A00)
#define	PINCNTL130	(CTRL_MODULE_BASE_ADDR + 0x0A04)
#define	PINCNTL131	(CTRL_MODULE_BASE_ADDR + 0x0A08)
#define	PINCNTL132	(CTRL_MODULE_BASE_ADDR + 0x0A0C)
#define	PINCNTL133	(CTRL_MODULE_BASE_ADDR + 0x0A10)
#define	PINCNTL135	(CTRL_MODULE_BASE_ADDR + 0x0A18)
#define	PINCNTL136	(CTRL_MODULE_BASE_ADDR + 0x0A1C)
//#define PINCNTL153  (CTRL_MODULE_BASE_ADDR + 0x0A60)
//#define PINCNTL156  (CTRL_MODULE_BASE_ADDR + 0x0A6C)
//#define PINCNTL157  (CTRL_MODULE_BASE_ADDR + 0x0A70)
//#define PINCNTL158  (CTRL_MODULE_BASE_ADDR + 0x0A74)
//#define PINCNTL159  (CTRL_MODULE_BASE_ADDR + 0x0A78)
//#define PINCNTL160  (CTRL_MODULE_BASE_ADDR + 0x0A7C)
//#define PINCNTL161  (CTRL_MODULE_BASE_ADDR + 0x0A80)
//#define PINCNTL162  (CTRL_MODULE_BASE_ADDR + 0x0A84)
//#define PINCNTL163  (CTRL_MODULE_BASE_ADDR + 0x0A88)
//#define PINCNTL164  (CTRL_MODULE_BASE_ADDR + 0x0A8C)
//#define PINCNTL165  (CTRL_MODULE_BASE_ADDR + 0x0A90)
//#define PINCNTL166  (CTRL_MODULE_BASE_ADDR + 0x0A94)
//#define PINCNTL167  (CTRL_MODULE_BASE_ADDR + 0x0A98)
//#define PINCNTL168  (CTRL_MODULE_BASE_ADDR + 0x0A9C)
//#define PINCNTL169  (CTRL_MODULE_BASE_ADDR + 0x0AA0)
//#define	PINCNTL170	(CTRL_MODULE_BASE_ADDR + 0x0AA4)
//#define	PINCNTL171	(CTRL_MODULE_BASE_ADDR + 0x0AA8)
//#define	PINCNTL172	(CTRL_MODULE_BASE_ADDR + 0x0AAC)
//#define	PINCNTL173	(CTRL_MODULE_BASE_ADDR + 0x0AB0)
//#define PINCNTL175  (CTRL_MODULE_BASE_ADDR + 0x0AB8)
#define PINCNTL204  (CTRL_MODULE_BASE_ADDR + 0x0B2C)
#define PINCNTL206  (CTRL_MODULE_BASE_ADDR + 0x0B34)
#define PINCNTL207  (CTRL_MODULE_BASE_ADDR + 0x0B38)
#define PINCNTL205  (CTRL_MODULE_BASE_ADDR + 0x0B30)
#define PINCNTL208  (CTRL_MODULE_BASE_ADDR + 0x0B3C)
#define PINCNTL209  (CTRL_MODULE_BASE_ADDR + 0x0B40)
#define PINCNTL210  (CTRL_MODULE_BASE_ADDR + 0x0B44)
#define PINCNTL211  (CTRL_MODULE_BASE_ADDR + 0x0B48)
#define PINCNTL212  (CTRL_MODULE_BASE_ADDR + 0x0B4C)
#define PINCNTL213  (CTRL_MODULE_BASE_ADDR + 0x0B50)
#define PINCNTL214  (CTRL_MODULE_BASE_ADDR + 0x0B54)
#define PINCNTL215  (CTRL_MODULE_BASE_ADDR + 0x0B58)
#define PINCNTL216  (CTRL_MODULE_BASE_ADDR + 0x0B5C)
#define PINCNTL217  (CTRL_MODULE_BASE_ADDR + 0x0B60)
#define PINCNTL218  (CTRL_MODULE_BASE_ADDR + 0x0B64)
#define PINCNTL219  (CTRL_MODULE_BASE_ADDR + 0x0B68)
#define PINCNTL220  (CTRL_MODULE_BASE_ADDR + 0x0B6C)
#define PINCNTL221  (CTRL_MODULE_BASE_ADDR + 0x0B70)
#define PINCNTL222  (CTRL_MODULE_BASE_ADDR + 0x0B74)
#define PINCNTL223  (CTRL_MODULE_BASE_ADDR + 0x0B78)
#define PINCNTL224  (CTRL_MODULE_BASE_ADDR + 0x0B7C)
#define PINCNTL225  (CTRL_MODULE_BASE_ADDR + 0x0B80)
#define PINCNTL226  (CTRL_MODULE_BASE_ADDR + 0x0B84)
#define PINCNTL227  (CTRL_MODULE_BASE_ADDR + 0x0B88)
#define PINCNTL232  (CTRL_MODULE_BASE_ADDR + 0x0B9C)
#define PINCNTL233  (CTRL_MODULE_BASE_ADDR + 0x0BA0)
#define PINCNTL234  (CTRL_MODULE_BASE_ADDR + 0x0BA4)
#define PINCNTL235  (CTRL_MODULE_BASE_ADDR + 0x0BA8)
#define PINCNTL236  (CTRL_MODULE_BASE_ADDR + 0x0BAC)
#define PINCNTL237  (CTRL_MODULE_BASE_ADDR + 0x0BB0)
#define PINCNTL238  (CTRL_MODULE_BASE_ADDR + 0x0BB4)
#define PINCNTL239  (CTRL_MODULE_BASE_ADDR + 0x0BB8)
#define PINCNTL240  (CTRL_MODULE_BASE_ADDR + 0x0BBC)
#define PINCNTL241  (CTRL_MODULE_BASE_ADDR + 0x0BC0)
#define PINCNTL242  (CTRL_MODULE_BASE_ADDR + 0x0BC4)
#define PINCNTL243  (CTRL_MODULE_BASE_ADDR + 0x0BC8)
#define PINCNTL244  (CTRL_MODULE_BASE_ADDR + 0x0BCC)
#define PINCNTL245  (CTRL_MODULE_BASE_ADDR + 0x0BD0)
#define PINCNTL246  (CTRL_MODULE_BASE_ADDR + 0x0BD4)
#define PINCNTL247  (CTRL_MODULE_BASE_ADDR + 0x0BD8)
#define PINCNTL248  (CTRL_MODULE_BASE_ADDR + 0x0BDC)
#define PINCNTL249  (CTRL_MODULE_BASE_ADDR + 0x0BE0)
#define PINCNTL250  (CTRL_MODULE_BASE_ADDR + 0x0BE4)
#define PINCNTL251  (CTRL_MODULE_BASE_ADDR + 0x0BE8)
#define PINCNTL252  (CTRL_MODULE_BASE_ADDR + 0x0BEC)
#define PINCNTL253  (CTRL_MODULE_BASE_ADDR + 0x0BF0)
#define PINCNTL254  (CTRL_MODULE_BASE_ADDR + 0x0BF4)
#define PINCNTL255  (CTRL_MODULE_BASE_ADDR + 0x0BF8)
#define PINCNTL256  (CTRL_MODULE_BASE_ADDR + 0x0BFC)
#define PINCNTL257  (CTRL_MODULE_BASE_ADDR + 0x0C00)
#define PINCNTL258  (CTRL_MODULE_BASE_ADDR + 0x0C04)
#define PINCNTL263  (CTRL_MODULE_BASE_ADDR + 0x0C18)
#define PINCNTL264  (CTRL_MODULE_BASE_ADDR + 0x0C1C)
#define PINCNTL270  (CTRL_MODULE_BASE_ADDR + 0x0C34)



 /*   DDR Config   */
#define    DDR_FREQ	  800 // 333MHz
 /****************** PLL Configuration ******************************************/

     /***    PLL,Control Base Adress  Base Address   ***********/
// #define PLL_BASE_ADDRESS         0x481C5000
 #define CONTROL_BASE_ADDRESS     0x48140000
 #define OSC_SRC_CTRL            (PLL_BASE_ADDRESS + 0x02c0)
 #define ARM_SRC_CLK             (PLL_BASE_ADDRESS + 0x02c4)

 /***    Top Level ADPLLJ  Base Address   ***********/
 #define L3_PLL_BASE             (PLL_BASE_ADDRESS + 0x110)
 #define IVA_PLL_BASE            (PLL_BASE_ADDRESS + 0x0E0)
 #define DSS_PLL_BASE            (PLL_BASE_ADDRESS + 0x170)
 #define SGX_PLL_BASE            (PLL_BASE_ADDRESS + 0x0B0)
 #define DSP_PLL_BASE            (PLL_BASE_ADDRESS + 0x080)
 #define ISS_PLL_BASE            (PLL_BASE_ADDRESS + 0x140)
 #define USB_PLL_BASE            (PLL_BASE_ADDRESS + 0x260)
 #define AUDIO_PLL_BASE          (PLL_BASE_ADDRESS + 0x230)
 #define VIDEO_0_PLL_BASE        (PLL_BASE_ADDRESS + 0x1A0)
 #define VIDEO_1_PLL_BASE        (PLL_BASE_ADDRESS + 0x1D0)
 #define HDMI_PLL_BASE           (PLL_BASE_ADDRESS + 0x200)
 #define DDR_PLL_BASE            (PLL_BASE_ADDRESS + 0x290)
 #define TIMER_CLKSRC			 (PLL_BASE_ADDRESS + 0x02E0)
 /**************** UART CLK_CONTROL REGISTERS *****************/
#define CM_ALWON_UART_0_CLKCTRL 	(PRCM_BASE_ADDR + 0x1550)
#define CM_ALWON_UART_1_CLKCTRL 	(PRCM_BASE_ADDR + 0x1554)
#define CM_ALWON_UART_2_CLKCTRL 	(PRCM_BASE_ADDR + 0x1558)
#define CM_ALWON_UART_3_CLKCTRL 	(PRCM_BASE_ADDR + 0x1580)
#define CM_ALWON_L3_SLOW_CLKSTCTRL	(PRCM_BASE_ADDR + 0x1400)


/*  UART register bits Value */
#define MODULEMODE_ENABLE    (0x2)
#define POWER_DOMAIN         (0x2)
#define POWER_DOMAIN_ENABLE  (0x2100)
//#define CLKIN                (192)


/*  GPIO Control Register*/
#define MLBP_SIG_IO_CTRL           (CTRL_MODULE_BASE_ADDR + 0x0E18)
#define MLBP_DAT_IO_CTRL           (CTRL_MODULE_BASE_ADDR + 0x0E1c)
#define CM_ALWON_GPIO_0_CLKCTRL    (PRCM_BASE_ADDR + 0x155C)
#define CM_ALWON_GPIO_1_CLKCTRL    (PRCM_BASE_ADDR + 0x1560)
#define CM_ALWON_GPIO_2_CLKCTRL    (PRCM_BASE_ADDR + 0x1564)

 /* IIC */
#define CM_ALWON_I2C_0_CLKSTCTRL     (PRCM_BASE_ADDR + 0x1564)
#define CM_ALWON_I2C_1_CLKSTCTRL     (PRCM_BASE_ADDR + 0x1568)
#define CM_ALWON_MCA_1_CLKSTCTRL     (PRCM_BASE_ADDR + 0x1544)
#define CM_ALWON_MCA_2_CLKSTCTRL     (PRCM_BASE_ADDR + 0x1548)//??
#define CM_HDVPSS_CLKSTCTRL          (PRCM_BASE_ADDR + 0x0800)
#define CM_HDVPSS_HDVPSS_CLKCTRL     (PRCM_BASE_ADDR + 0x0820)
#define CM_HDVPSS_HDMI_CLKCTRL       (PRCM_BASE_ADDR + 0x0824)
#define CM_ALWON_WLAN_HS_0_CLKSTCTRL (PRCM_BASE_ADDR + 0x161C)/* WLAN*/

/* Ethernet*/
#define MC_ALWON_ETHNET_CLKSTCTRL  (PRCM_BASE_ADDR + 0x1404)
#define MC_ALWON_ETH_0_CLKSTCTRL   (PRCM_BASE_ADDR + 0x15D4)
#define MC_ALWON_ETH_1_CLKSTCTRL   (PRCM_BASE_ADDR + 0x15D8)
#define CM_ALWON_DCAN_0_CLKCTRL    (PRCM_BASE_ADDR + 0x1618)
#define SERDES_REFCLK_CTL 	       (CTRL_MODULE_BASE_ADDR + 0xE24)
#define GMII_SELECT                (CTRL_MODULE_BASE_ADDR + 0x0650)
#define CM_ALWON_GPMC_CLKCTRL		(PRCM_BASE_ADDR + 0x15D0)


/*MMC*/
#define CM_ALWON_MMC_HS_1_CLKSTCTRL     (PRCM_BASE_ADDR + 0x1620)
#define CM_ALWON_WLAN_HS_0_CLKSTCTRL		(PRCM_BASE_ADDR + 0x161C)/* WLAN*/


 /*************************************************************************************************************
       						     ADPLLJ CLKCNTRL REGISTER CONFIGURATIONS

 ***************************************************************************************************************/
 	// ADPLLJ_CLKCRTL_Register Value Configurations

 	#define ADPLLJ_CLKCRTL_HS2       0x00000801 //HS2 Mode,TINTZ =1  --used by all PLL's except HDMI
 	#define ADPLLJ_CLKCRTL_HS1       0x00001001 //HS1 Mode,TINTZ =1  --used only for HDMI
 	#define ADPLLJ_CLKCRTL_CLKDCO    0x200a0000 // Enable CLKDCOEN,CLKLDOEN,CLKDCOPWDNZ -- used for HDMI,USB

 /******************* USB control register ********************/
#define CM_ALWON2_USB_CLKCTRL       (PRCM_BASE_ADDR + 0x0558)
#define RM_ALWON2_RSTCTRL           (PRCM_BASE_ADDR + 0x0B10)
#define USB_PLL_BASE                (PLL_BASE_ADDRESS + 0x260)


 /********   SATA PLL REGISTERS   **************/
  #define SATA_PLLCFG0            (CONTROL_BASE_ADDRESS+0x720)
  #define SATA_PLLCFG1            (CONTROL_BASE_ADDRESS+0x724)
  #define SATA_PLLCFG2            (CONTROL_BASE_ADDRESS+0x728)
  #define SATA_PLLCFG3            (CONTROL_BASE_ADDRESS+0x72c)
  #define SATA_PLLCFG4            (CONTROL_BASE_ADDRESS+0x730)
  #define SATA_PLLSTATUS          (CONTROL_BASE_ADDRESS+0x734)
  #define SATA_RXSTATUS           (CONTROL_BASE_ADDRESS+0x738)
  #define SATA_TXSTATUS           (CONTROL_BASE_ADDRESS+0x73c)



 /********** ADPLL intrnal Offset Registers  ***********/
#define  CLKCTRL 				(0x4)
#define  TENABLE 				(0x8)
#define  TENABLEDIV 			(0xC)
#define  M2NDIV  				(0x10)
#define  MN2DIV 				(0x14)
#define  ADPLL_STATUS 			(0x24)


/*********** MODENA ADPLLS REGISTERS  *********/
#define MODENAPLL_CLKCTRL		(PLL_BASE_ADDRESS+0x04c)
#define MODENAPLL_TENABLE		(PLL_BASE_ADDRESS+0x050)
#define MODENAPLL_TENABLEDIV    (PLL_BASE_ADDRESS+0x054)
#define MODENAPLL_M2NDIV    	(PLL_BASE_ADDRESS+0x058)
#define MODENAPLL_MN2DIV    	(PLL_BASE_ADDRESS+0x05c)
#define MODENAPLL_STATUS		(PLL_BASE_ADDRESS+0x06c)

/* USB control bits*/
#define USB_CLK_EN            (0x2)
#define GPIO_EN               (0x2)
#define GPIO_SEL              (0x80)
#define DISABLE_LOCAL_RESET   (0x9F)
#define MUX_MODE_RSV_PLLTYPE  (0x00060001)
#define USB_DRVVBUS           (0x00060080)

/*Enable CLKDCOEN,CLKLDOEN,CLKDCOPWDNZ -- used for HDMI,USB*/


#define NOI   11 /* Number of loop */
#define NUMBER_OF_LOOP  1

#define PARAM_VOID   (0u)
#define U8MACASP_NUM (2u)
#define CACHE_ENABLE (1u)
#define INIT_VAL     (0u)
#define TIME_OUT     (0xFFFFFF)


/*********** MACRO Functions ************/
#define WR_MEM_32(u32addr, u32data) (*(volatile unsigned int*)(u32addr) = (UINT32)(u32data))
#define RD_MEM_32(u32addr) (*(volatile unsigned int*)(u32addr))

 /**
  * @brief Define how platform_read should behave.
  *    These write types can be set in the init structure
  */
 typedef enum {
     PLATFORM_READ_UART,
     /** <Read from the UART */
     PLATFORM_READ_SCANF
     /** <Read from scanf -- CCS console */
 } READ_info;
 /**
  *\brief :  Define how platform_write should behave.
  *          These write types can be set in the init structure
  */
 typedef enum {
     PLATFORM_WRITE_UART,
     /** <Write to the UART */
     PLATFORM_WRITE_PRINTF,
     /** <printf mapped output -- CCS console */
     PLATFORM_WRITE_ALL
     /** <write all - default configuration */
 } WRITE_info;


 typedef struct diagTestTable_s
 {
 	const char *testName;
 	STATUS (*testFunction)(void *);
 	void  *args;
 	UINT32  pass;
 	UINT32 fail;
 }diagTestTable_t;

 /*
  *====================
  * Diagnostic use
  *====================
  */

#define	MAX_LEN	200
 static WRITE_info write_type = PLATFORM_WRITE_UART ;
 static READ_info read_type = PLATFORM_READ_UART ;
 /*
  *===================
  * structure
  *===================
  */
 typedef struct controllerReg {
 	UINT8 res1[0x110];
 	UINT32 sysconfig;
 	UINT32 sysstatus;
 	UINT8 res2[0x14];
 	UINT32 con;
 	UINT8 res3[0xD4];
 	UINT32 blk;
 	UINT32 arg;
 	UINT32 cmd;
 	UINT32 rsp10;
 	UINT32 rsp32;
 	UINT32 rsp54;
 	UINT32 rsp76;
 	UINT32 data;
 	UINT32 pstate;
 	UINT32 hctl;
 	UINT32 sysctl;
 	UINT32 stat;
 	UINT32 ie;
 	UINT8 res4[0x8];
 	UINT32 capa;
 }SDIO_controllerReg_t;



 static char	write_buffer[MAX_LEN];


 /*
  *=====================
  * Functions prototype
  *=====================
  */


 static void run_all_tests
 (
 	void
 );
 /***
  * \brief : Interface's Handler function for DM8127_CSK.
  *
  * \b \Descr : This function control the execution of Interface's diagnostic test
  * \n          This function is designed in such way that user can test
  * \n          All Interfaces .
  * \n          Or run all tests at a time. To select a particular test user has to
  * \n          Enable the switch base by defining the SWITCH Macro.
  *
  * \param : VOID
  *
  * \return: SUCCESS   on successful execution
  * \n       FAILED    if fail at any instance.
  */
 SINT32 Long_run_test
 (
     void
 );
 /***
  * \brief : Interface's Handler function for DM8127_CSK.
  *
  * \b \Descr : This function control the execution of Interface's diagnostic test
  * \n          This function is designed in such way that user can perform the
  * \n          particular test by selecting the option from the given menu.
  * \n          Or run all tests at a time. To select a particular test user has to
  * \n          Enable the switch base by defining the SWITCH Macro.
  *
  * \param : VOID
  *
  * \return: SUCCESS   on successful execution
  * \n       FAILED    if fail at any instance.
  */


 SINT32 diag_main
 (
     void
 );
 /***
  * \brief : Uart print fumnction for the formate specifier.
  *
  * \b \Descr : This function takes the parameters as formate specifiers as well
  * \n          as the parameter value which has to be print. fially the data
  * \n          is sent on the serial terminal.
  *
  * \param :   const char *  [IN]  formate specifier and data that has to be print
  * \return:   SINT32        Number of character that sent to the UART
  */
 extern SINT32 platform_write
 (
 	const char *format, ...
 );

 /**
  * \brief : Uart receive fumnction.
  *
  * \b \Descr : This function read the data/ value from the UART0
  * \n
  * \n
  *
  * \param :   *data    [OUT]  formate specifier and data that has to be print
  * \return:   length   [IN]   Number of character that sent to the UART
  */
SINT32 platform_read
(
	char *data,
	UINT32 length
);
 /***
  * \brief : UART initialization function for the serial terminal.
  *
  * \b \Desc: This function initialzes the UART 0 with baud rate
  * \v        115200.
  *
  * \param : VOID
  * \return: s32status  SUCCESS  successfully initialized
  * \n                  FAILED   failed to initialized
  */

STATUS UART_Init
(
	void
);

/***
 * \brief:    String send funtion to the UART 0 (serial terminal).
 *
 * \b \Descr: This function send a string to the serial terminal.
 *
 * \param : const char*  [IN]  string that has to send on the serial terminal.
 * \return: VOID
 */

void Uart_stringSend
(
	const char* pu8string
);

const char* convert
(
	UINT32 num ,
	SINT32 base
); 		//Convert integer number into octal, hex, etc.

void CSK_print
(
	char* format,...
);

/***
 * \brief : GPIO bank 0 pin control function.
 *
 * \b \Descr : This function takes the pin number for GPIO bank zero
 * \n          and it will make it HIGH or LOW as per 2nd parameter of
 * \n          the function.
 *
 * \param : PIN number [IN] pin that has to be changed.
 * \n       pin val    [IN] new value for a gien pin
 *
 * \return: Always true.
 */

int set_gpio_bank0
(
	SINT32 gpio,
	SINT32 value
);
/***
 * \brief : GPIO bank 1 pin control function.
 *
 * \b \Descr : This function takes the pin number for GPIO bank One
 * \n          and it will make it HIGH or LOW as per 2nd parameter of
 * \n          the function.
 *
 * \param : pin number [IN] pin that has to be changed.
 * \n       pin val    [IN] new value for a gien pin
 *
 * \return: Always true.
 */
int set_gpio_bank1
(
	SINT32 gpio,
	SINT32 value
);

/***
 * \brief : Delay routine
 *
 * \b \Descr : This routine give the delay into the calling routine
 * \n          based on the input as a parameter.
 *
 * \param : s32delay [IN] delay count.
 *
 * \return: VOID
 */

int set_gpio_bank2
(
	int gpio,
	int value
);

/***
 * \brief : GPIO bank 3 pin control function.
 *
 * \b \Descr : This function takes the pin number for GPIO bank zero
 * \n          and it will make it HIGH or LOW as per 2nd parameter of
 * \n          the function.
 *
 * \param : PIN number [IN] pin that has to be changed.
 *          pin val    [IN] new value for a gien pin
 *
 * \return: Always true.
 */

int set_gpio_bank3
(
	int gpio,
	int value
);
/****
 *\brief: SD/MMC handler function.
 *
 *\descr: This function initialize the SDIO device to detect the SD/MMC device.
 *
 *\param: VOID
 *\return:  SUCCESS on successful detection of SD/MMC card.
 *          FAILED failed to detect SD card
 *
 */
extern int SD_MMC_test
(
	void *testargs
);
extern STATUS DDR3_test
(
		void *cache_enable
);

extern STATUS emac_gmii_test
(
	void *testargs
);

extern STATUS Audio_Test
(
	void *testargs
);
/***
 * \brief: Bluetooth test function.
 *
 * \b \Descr: This routine initialize the Bluetooth as well as Respective uart
 * \n         It detedt the card status and read the device ID.
 *
 * \param: VOID
 * \return: SUCCESS  on successful device detection
 *         FAILED   failed to detect the device
 */
extern STATUS BT_Test
(
	void *testargs
);
/***
 * \brief: chip ID detection routine.
 *
 * \b \descr: This function takes sdio base address as input and it send command
 * \n         to the sdio device top get the vendor information from the chip.
 *
 * \n         Once it collect the vendor ID from the device it update the same
 * \n         to the second parameter (as output).
 *
 * \param:    Sdio_base  [IN]  base address of the SDIO device
 * \n         vendor     [OUT] CHip ID
 *
 * \return:   SUCCESS  successfully id detection
 * \n         FAILURE  failed to detect the chip ID
 */
int get_sdio_chipid
(
	SDIO_controller_t * Sdio_base,
	UINT32 *vendor
);

/***
 * \brief: WLAN test handler function.
 *
 * \b \descr: This function initialize the SDIO and start detection for
 *         WLAN card on DM8127 board.
 *
 * \param: VOID
 * \return: SUCCESS on successful detection the WLAN card on the board
 * \n       FAILED  failed to detct the WLAN card on the connected board.
 */
extern STATUS WLAN_Test
(
		void *testargs
);
/***
 * \brief : Routine to Test Nandflash device .
 *
 * \b \Descr: This routine tests first 4 blocks of device without Spare area.
 * \n         Uncommenting the  loop tests with spare area.This routine first
 * \n         erases the blocks.Writes into the device and read the same and
 * \n         Compares both.
 *
 * \param   VOID
 * \return : NAND_TEST_PASS  Successfully pass
 *           NAND_TEST_FAIL  NAND test Failed
 */
extern STATUS NAND_Flash_Test
(
		void *testargs
);

void LED_PIN_MUX();

/***
 * \brief: LED status handler function.
 *
 * \descr: This is the switching function for the LED from ON
 *         state to OFF state and from the OFF state to on function.
 *
 * \param:  VOID
 *
 * \return: Always SUCCESS
 */
extern STATUS led_test
(
	void *testargs
);
 extern STATUS usb_test
 (
	 void *testargs
 );

 extern STATUS uart_loopback_test
 (
      void
 );

 /****
  * \brief : Switch handler function
  */
 extern STATUS switch_test
 (
	 void *testargs
 );
 void GPIO0ClkEnable(void);
 void GPIO1ClkEnable(void);
 void GPIO2ClkEnable(void);
/*
 *=====================
 * Functions prototype
 *=====================
 */


 /***
  *\brief : Routine to run the test cases for DM8127_CSK interfaces.
  *
  *\Descr : This routine takes the function handler and param as input and
  *         executes the appropriate function handlers and prints the result
  *         as success or failure.
  *
  *\param :  funchandle  [IN]  handler function for which the test has to be
  *                            performed.
  *          testname    [IN]  Name of the test case.
  *          param       [IN]  8 bit parameter for the funchandle.
  *          testid      [IN]  testid, which is to keep count of number of test.
  *
  *\return  None
  *
  */
STATUS PLL_SETUP
(
    void
);

/***
 * \brief : Routine to run the test cases for DM8127_CSK interfaces.
 *
 * \b \Descr : This routine takes the function handler and param as input and
 * \n          executes the appropriate function handlers and prints the result
 * \n        as success or failure.
 *
 * \param :  funchandle  [IN]  handler function for which the test has to be
 *                             performed.
 * \n        testname    [IN]  Name of the test case.
 * \n        param       [IN]  8 bit parameter for the funchandle.
 * \n        testid      [IN]  testid, which is to keep count of number of test.
 *
 * \return  VOID
 *
 */
 void TEST_execute
 (
 	STATUS ( *funchandle )( SINT16),
 	SINT8 *testname,
 	SINT8 param,
 	SINT16 testid
 );
STATUS WLAN_Init
(
    void
);

 STATUS AudioInit
(
	void
);

STATUS BT_init
(
    void
);
//  	STATUS* s32status
 SINT32 Platform_init
 (
 	void
 );
STATUS EthernetInit
(
	void
);

STATUS NAND_config
(
     void
);

static void displayMenu
(
	void
);


extern diagTestTable_t gDiagTestTable[PLATFORM_TEST_COUNT];

#ifdef __cplusplus
}             /* End of extern C */
#endif        /* #ifdef __cplusplus */

#endif        /*_ DM8127_COMMON_H_ */

/* end of the file */
